<?php namespace Jenssegers\Mongodb\Relations;

class BelongsTo extends \Illuminate\Database\Eloquent\Relations\BelongsTo {

	/**
	 * Set the base constraints on the relation query.
	 *
	 * @return void
	 */
	public function addConstraints()
	{
		// For belongs to relationships, which are essentially the inverse of has one
		// or has many relationships, we need to actually query on the primary key
		// of the related models matching on the foreign key that's on a parent.
		$key = $this->related->getKeyName();

		$this->query->where($key, '=', $this->parent->{$this->foreignKey});
	}

	/**
	 * Set the constraints for an eager load of the relation.
	 *
	 * @param  array  $models
	 * @return void
	 */
	public function addEagerConstraints(array $models)
	{
		// We'll grab the primary key name of the related models since it could be set to
		// a non-standard name and not "id". We will then construct the constraint for
		// our eagerly loading query so it returns the proper models from execution.
		$key = $this->related->getKeyName();

		$this->query->whereIn($key, $this->getEagerModelKeys($models));
	}

}